<?php

namespace App\Http\Controllers\Crm\Payment;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use DB;

class PaymentController extends Controller
{
    // Payment Link Generator
    public function index(){
        if (session()->get('id') != null) {
            $brands = DB::table('brands')->get();
            return view('pages.generate-payment',compact('brands'));
        } else {

            return redirect()->route('login');
        }
    }
    
     // Payment Link Generator Out source
    public function paymentLinkOutSource(){
        $brands = DB::table('brands')->get();
        return view('payment-link-out',compact('brands'));
    }
    
     // Payment Link Generator Out source For Content
    public function paymentLinkOutSourceContent(){
        $brands = DB::table('brands')->where('type','Content')->get();
        return view('payment-link-out-content',compact('brands'));
    }
    
    // Paypal Link Generator
    public function paypalGenerator(){
        return view('pages.paypal-generator');
    }
    
    // Payment Link Generator Post
    public function paymentApi(Request $request){
        
        $brands = DB::table('brands')->where('id', $request->brand_id)->first();
        $data = [
            'item' => $request->item,
            'amount' => $request->amount,
            'payment_method' => $request->payment_method,
            'agent' => $request->agent,
            'brand_id' => $request->brand_id,
            'user_id' => $request->user_id
        ];
        
        $insert = DB::table('payment')->insertGetId($data);
        
        if($insert){
            $pay = [
                    'token_id' => $insert,
                    'status' => 'Active'
                ];
            $payment_log = DB::table('payment_log')->insert($pay);
            if($payment_log){
                if($request->payment_method == "authorize"){
                    return response()->json(['message' => $brands->url. "authorize-payment/info.php?token=". $insert ]);
                }elseif($request->payment_method == "authorize-two"){
                    return response()->json(['message' => $brands->url. "authorize-payments/info.php?token=". $insert ]);
                }elseif($request->payment_method == "stripe-ok"){
                    return response()->json(['message' => $brands->url. "okl-payment/info.php?token=". $insert ]);
                }elseif($request->payment_method == "square"){
                    return response()->json(['message' => $brands->url. "up-payment/info.php?token=". $insert ]);
                }elseif($request->payment_method == "stripe-hbm"){
                    return response()->json(['message' => $brands->url. "hbm-payment/info.php?token=". $insert ]);
                }elseif($request->payment_method == "stripe-expert"){
                    return response()->json(['message' => $brands->url. "expert-payment/info.php?token=". $insert ]);
                }elseif($request->payment_method == "stripe-expert-secure"){
                    return response()->json(['message' => $brands->url. "expert-secure-payment/info.php?token=". $insert ]);
                }elseif($request->payment_method == "stripe-digital-hub"){
                    return response()->json(['message' => $brands->url. "digital-hub-solutions/info.php?token=". $insert ]);
                }elseif($request->payment_method == "stripe-bux"){
                    return response()->json(['message' => $brands->url. "bux-payment/info.php?token=". $insert ]);
                }
                else{
                    return response()->json(['message' => $brands->url. "payment/info.php?token=". $insert ]);
                }
            }else{
                return response()->json(['message' => "something went wrong while creating log" ]);
            }
        }
        else{
            return response()->json(['message' => "not success" ]);
        }
    }
    
    
    // Get Card Details Generator
    public function cardDetialGenerator(){
        if (session()->get('id') != null) {
            $brands = DB::table('brands')->get();
            return view('pages.generate-card',compact('brands'));
        } else {

            return redirect()->route('login');
        }
    }
    
    // Payment Link Generator Post
    public function cardPaymentApi(Request $request){
        
        $brands = DB::table('brands')->where('id', $request->brand_id)->first();
        $data = [
            'item' => $request->item,
            'amount' => $request->amount,
            'brand_id' => $request->brand_id,
        ];
        
        return response()->json(['message' => $brands->url. "charge?nature=". $request->item ."&amount=". $request->amount ."&b=". $request->brand_id ]);
       
    }
}
