<?php echo $__env->make('includes.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php echo $__env->make('includes.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<!-- Page wrapper  -->
<!-- ============================================================== -->
<div class="page-wrapper">
    <!-- ============================================================== -->
    <!-- Bread crumb and right sidebar toggle -->
    <!-- ============================================================== -->
    <div class="row page-titles">
        <div class="col-md-5 align-self-center">
            <h3 class="text-themecolor">Brands</h3>
        </div>
        <div class="col-md-7 align-self-center">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="javascript:void(0)">Home</a></li>
                <li class="breadcrumb-item">brands</li>
                <li class="breadcrumb-item active">Brands</li>
            </ol>
        </div>
        <div>

        </div>
    </div>
    <!-- ============================================================== -->
    <!-- End Bread crumb and right sidebar toggle -->
    <!-- ============================================================== -->
    <!-- ============================================================== -->
    <!-- Container fluid  -->
    <!-- ============================================================== -->
    <div class="container-fluid">
        <!-- ============================================================== -->
        <!-- Start Page Content -->
        <!-- ============================================================== -->
        <div class="row">
            <div class="col-12">

                <div class="card">
                    <div class="card-body">

                        <button type="button" class="btn btn-info btn-circle" data-toggle="modal" data-target="#addbrandModal" style="float:right;">
                            <i class="fa fa-plus"></i>
                        </button>

                        <h4 class="card-title">Brands</h4>
                        <h6 class="card-subtitle">Brands</h6>
                        <div class="table-responsive m-t-40">
                            <table id="brandTable" class="table table-bordered table-striped">
                                <thead>
                                <tr>
                                    <th>Name</th>
                                    <th>Url</th>
                                    <th>Action</th>
                                </tr>
                                </thead>
                                <tbody>

                                <?php if(count($brands) > 0): ?>
                                <?php $__currentLoopData = $brands; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($row->name); ?></td>
                                    <td><?php echo e($row->url); ?></td>
                                    <td class="text-nowrap">
                                        <a href="javascript:void(0)" class="btnSelect" data-toggle="tooltip" data-original-title="Edit" data-action="edit" data-rowid="<?php echo e($row->id); ?>"> <i class="fa fa-pencil text-inverse m-r-10"></i> </a>
                                        <a href="javascript:void(0)" class="btnSelect" data-toggle="tooltip" data-original-title="Close" data-action="delete" data-rowid="<?php echo e($row->id); ?>"> <i class="fa fa-close text-danger"></i> </a>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php else: ?>

                                    <h4 align="center" class="no-record">No Record</h4>

                                <?php endif; ?>

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>
        </div>
        <!-- ============================================================== -->
        <!-- End PAge Content -->
        <!-- ============================================================== -->
        <!-- ============================================================== -->
        <!-- Right sidebar -->
        <!-- ============================================================== -->
        <!-- .right-sidebar -->

        <!-- ============================================================== -->
        <!-- End Right sidebar -->
        <!-- ============================================================== -->
    </div>
    <!-- ============================================================== -->
    <!-- End Container fluid  -->


<!-- Action Modal -->
<div class="modal fade" id="addbrandModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="exampleModalLongTitle">Add Brand</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body" style="height: 500px; min-height: 500px; overflow-y: scroll;">
                <div class="container-fluid">

                <form class="form-material m-t-40" method="POST" action="<?php echo e(route('add_brands')); ?>">
                <?php echo csrf_field(); ?>
                    <div class="form-group">
                        <label>Name</label>
                        <input type="text" class="form-control" name="name" value="" placeholder="Brand Name" required>
                    </div>
                    <div class="form-group">
                        <label>URL</label>
                        <input type="url" class="form-control" name="url" value="" placeholder="www.staffshaw.com" required>
                    </div>

                    <input type="hidden" name="id" value="<?php echo e(Session::get('id')); ?>">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="d-flex bd-highlight align-items-center">

                                <div class="flex-grow-1 p-2 bd-highlight">
                                    <button type="submit" class="btn btn-primary form-control">Add Brand</button>
                                </div>
                            </div>
                        </div>
                    </div>

                </form>

                </div>

            </div>

        </div>
    </div>
</div>


<!-- Edit Action Modal -->
<div class="modal fade" id="editbrandModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="exampleModalLongTitle">Edit Brand</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body" style="height: 500px; min-height: 500px; overflow-y: scroll;">
                <div class="container-fluid">
                    <form method="POST" action="<?php echo e(route('update_brands')); ?>">
                        <?php echo csrf_field(); ?>
                        <div class="form-group">
                            <label>Name</label>
                            <input type="text" class="form-control brandname" name="brandname" placeholder="Brand Name" required>
                        </div>
                        <div class="form-group">
                            <label>URL</label>
                            <input type="url" class="form-control brandurl" name="brandurl" placeholder="www.staffshaw.com" required>
                        </div>

                        <input type="hidden" name="editsenderid" value="<?php echo e(Session::get('id')); ?>">
                        <input type="hidden" name="editbrandid" value="" class="editbrandid">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="d-flex bd-highlight align-items-center">

                                    <div class="flex-grow-1 p-2 bd-highlight">
                                        <button type="submit" class="btn btn-primary form-control">Update</button>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </form>
                </div>

            </div>

        </div>
    </div>
</div>

<div id="deletebrandModal" class="modal fade in" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-confirm modal-dialog-centered">
        <div class="modal-content">
            <!-- <div class="modal-header">

                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
            </div> -->
            <div class="modal-body" align="center">
                <img src="<?php echo e(asset('public/assets/images/close.png')); ?>" width="70" height="70">
                <h4 class="modal-title" style="color: #636363; margin-top: 10px;">Are you sure?</h4>
                <p style="color: #999999">Do you really want to delete this records?</p>
                <form method="POST" action="<?php echo e(route('delete_brands')); ?>">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="deletebrandid" class="deletebrandid" id="deleteleadblastid">
                    <button type="submit" class="btn btn-danger">Delete</button>
                    <button type="button" class="btn btn-info" data-dismiss="modal">Cancel</button>
                </form>
            </div>
            <!-- <div class="modal-footer" align="center">

            </div> -->
        </div>
    </div>
</div>

<?php echo $__env->make('includes.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<script type="text/javascript">

    $(document).ready(function(){

        // code to read selected table row cell data (values).
        $("#brandTable").on('click','.btnSelect',function(){

            var action = $(this).data('action');
            var rowid = $(this).data('rowid');

            if(action == 'edit'){

                // get the current row
                var currentRow = $(this).closest("tr");

                var brandname = currentRow.find("td:eq(0)").text();
                var brandurl = currentRow.find("td:eq(1)").text();

                $('.brandname').val(brandname);
                $('.brandurl').val(brandurl);
                $('.editbrandid').val(rowid);

                $('#editbrandModal').modal('show');
            }
            else{
                $('.deletebrandid').val(rowid);
                $('#deletebrandModal').modal('show');
            }

        }

        );
    });

</script>
<?php /**PATH D:\xampp\htdocs\staffshaw_crm\resources\views/pages/brands.blade.php ENDPATH**/ ?>