<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateUpsalesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('upsales', function (Blueprint $table) {
            $table->increments('id');
            $table->text('client_message');
            $table->decimal('total_amount',10,2);
            $table->decimal('paid_amount',10,2);
            $table->string('payment_method',250);
            $table->string('status',100);
            $table->string('lead_type',200);
            $table->string('progress_status',100);
            $table->string('completion_date',200);
            $table->string('chat_ref',200);
            $table->string('chat_ref_detail',250);
            $table->integer('lead_id');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('upsales');
    }
}
