<?php $__env->startSection('page_style'); ?>
<link rel="stylesheet" href="<?php echo e(asset('public/backend/image-upload/upload.css')); ?>"> 
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<main id="js-page-content" role="main" class="page-content">
    <div class="row">
        <div class="col-md-11">
            <div class="subheader">
                <h1 class="subheader-title">
                    <i class="subheader-icon fal fa-table"></i> Blogs
                    <small>
                        All your blogs are here
                    </small>
                </h1>
            </div>
        </div>
        <div class="col-md-1" align="center">
            <button type="button" class="btn btn-success waves-effect waves-themed" data-toggle="modal" data-target="#add-modal" ><i class="fa-2x ni ni-big-plus"></i></button>
        </div>
    </div>
    
    <div class="row">
        <div class="col-xl-12">
            <div id="panel-1" class="panel">
                <div class="panel-hdr">
                    <h2>Records</h2>
                    <div class="panel-toolbar">
                        <button class="btn btn-primary btn-sm" data-toggle="dropdown">Table Style</button>
                        <div class="dropdown-menu dropdown-menu-animated dropdown-menu-right position-absolute pos-top">
                            <button class="dropdown-item active" data-action="toggle" data-class="table-bordered" data-target="#dt-basic-example">Bordered Table</button>
                            <button class="dropdown-item" data-action="toggle" data-class="table-sm" data-target="#dt-basic-example">Smaller Table</button>
                            <button class="dropdown-item" data-action="toggle" data-class="table-dark" data-target="#dt-basic-example">Table Dark</button>
                            <button class="dropdown-item active" data-action="toggle" data-class="table-hover" data-target="#dt-basic-example">Table Hover</button>
                            <button class="dropdown-item active" data-action="toggle" data-class="table-stripe" data-target="#dt-basic-example">Table Stripped</button>
                            <div class="dropdown-divider m-0"></div>
                        </div>
                    </div>
                </div>
                <div class="panel-container show">
                    <div class="panel-content">
                        <!-- datatable start -->
                        <table id="dt-basic-example" class="table table-bordered table-hover table-striped w-100">
                            <thead>
                                <tr>
                                    <th>Id</th>
                                    <th>Brand</th>
                                    <th>Title</th>
                                    <th>Author</th>
                                    <th>Feartured Image</th>
                                    <th>Created at</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                
                                <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($row->id); ?></td>
                                    <td><?php echo e($row->brand_name); ?></td>
                                    <td><?php echo e($row->title); ?></td>
                                    <td><?php echo e($row->user_first_name); ?> <?php echo e($row->user_last_name); ?></td>
                                    <td>
                                        <img src="<?php echo e(asset('public/backend/img/blogs')); ?>/<?php echo e($row->image); ?>" width="50" height="30">
                                    </td>
                                    <td><?php echo e(Carbon\Carbon::parse($row->created_at)->format('d-m-Y h:i A')); ?></td>
                                    <td>
                                        <button type="button" class="btn btn-info waves-effect waves-themed edit-blog" title="Edit"  data-toggle="modal" data-target="#edit-modal" data-id="<?php echo e($row->id); ?>"><i class="ni ni-note"></i></button>
                                        |
                                        <button type="button" class="btn btn-danger waves-effect waves-themed delete-blog" title="Delete" data-rowid="<?php echo e($row->id); ?>"><i class="ni ni-trash"></i></button>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                
                            </tbody>
                            <tfoot>
                                <tr>
                                    <th>Id</th>
                                    <th>Brand</th>
                                    <th>Title</th>
                                    <th>Author</th>
                                    <th>Image</th>
                                    <th>Created at</th>
                                    <th>Action</th>
                                </tr>
                            </tfoot>
                        </table>
                        <!-- datatable end -->
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>


<div class="modal fade" id="add-modal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header bg-success-900">
                <h4 class="modal-title">
                    Add Blog
                </h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true"><i class="fal fa-times"></i></span>
                </button>
            </div>
            <div class="modal-body">
                <form method="POST" class="needs-validation" action="<?php echo e(route('blog_post')); ?>" enctype="multipart/form-data" id="add-blog-btn" novalidate>
                    <?php echo csrf_field(); ?>
                    <div class="row p-2">
                        <div class="col-md-12">
                            <div class="form-group">
                                <h5 for="validationCustom01"><b>Title :</b></h5>
                                <input type="text" name="title" class="form-control" placeholder="Enter blog title" required>
                            </div>
                        </div>
                    </div>

                    <div class="row p-2">
                        <div class="col-md-12">
                            <div class="form-group">
                                <h5 for="validationCustom01"><b>Description :</b></h5>
                                <textarea id="editor" class="form-control" name="description" placeholder="Enter blog description..." required></textarea>
                            </div>
                        </div>
                    </div>

                    <div class="row p-2">
                        <div class="col-md-12">
                            <div class="form-group">
                                <h5 for="validationCustom01"><b>Meta Title :</b></h5>
                                <input type="text" name="meta_title" class="form-control" placeholder="Enter blog meta title" >
                            </div>
                        </div>
                    </div>
                    <div class="row p-2">
                        <div class="col-md-12">
                            <div class="form-group">
                                <h5 for="validationCustom01"><b>Meta Description :</b></h5>
                                <textarea class="form-control" name="meta_description" placeholder="Enter blog meta description..."></textarea>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row p-2">
                        <div class="col-md-12">
                            <div class="form-group">
                                <h5 for="validationCustom01"><b>Brands :</b></h5>
                                <select class="brand-assigning form-control" name="brandid[]" multiple="multiple">
                                    <option value="">Select Brands</option>
                                    <?php $__currentLoopData = $brands; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($row->id); ?>"><?php echo e($row->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                    </div>
                    

                    <div class="row p-2">
                        <div class="col-md-12">
                            <div class="file-upload">
                              <button class="file-upload-btn" type="button" onclick="$('.file-upload-input').trigger( 'click' )">Add Image</button>

                              <div class="image-upload-wrap">
                                <input class="file-upload-input" type='file' name="file" onchange="readURL(this);" accept="image/*" />
                                <div class="drag-text">
                                  <h3>Drag and drop a file or select add Image</h3>
                                </div>
                              </div>
                              <div class="file-upload-content">
                                <img class="file-upload-image" src="#" alt="your image" />
                                <div class="image-title-wrap">
                                  <button type="button" onclick="removeUpload()" class="remove-image">Remove <span class="image-title">Uploaded Image</span></button>
                                </div>
                              </div>
                            </div>
                        </div>
                    </div>

                    <div class="row p-2">
                        <div class="col-md-12" align="center">
                            <div class="form-group">
                                <button type="submit" class="btn btn-primary">Save</button>
                            </div>
                        </div>
                    </div>
                </form>
                
            </div>
        </div>
    </div>
</div>


<div class="modal fade" id="edit-modal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header bg-info-900">
                <h4 class="modal-title">
                    Edit Blog
                </h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true"><i class="fal fa-times"></i></span>
                </button>
            </div>
            <div class="modal-body">
                <form method="POST" class="needs-validation" action="<?php echo e(route('edit_blog_post')); ?>" enctype="multipart/form-data" novalidate>
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="blog_id" id="blog-id">
                    <div class="row p-2">
                        <div class="col-md-12">
                            <div class="form-group">
                                <h5 for="validationCustom01"><b>Title :</b></h5>
                                <input type="text" name="edit_title" id="edit-title" class="form-control" placeholder="Enter blog title" required>
                            </div>
                        </div>
                    </div>

                    <div class="row p-2">
                        <div class="col-md-12">
                            <div class="form-group">
                                <h5 for="validationCustom01"><b>Description :</b></h5>
                                <textarea class="form-control ckeditor" id="edit-description" name="edit_description" placeholder="Enter blog description..." required></textarea>
                            </div>
                        </div>
                    </div>

                    <div class="row p-2">
                        <div class="col-md-12">
                            <div class="form-group">
                                <h5 for="validationCustom01"><b>Meta Title :</b></h5>
                                <input type="text" name="edit_meta_title" id="edit-meta-title" class="form-control" placeholder="Enter blog meta title" >
                            </div>
                        </div>
                    </div>
                    <div class="row p-2">
                        <div class="col-md-12">
                            <div class="form-group">
                                <h5 for="validationCustom01"><b>Meta Description :</b></h5>
                                <textarea class="form-control " name="edit_meta_description" id="edit-meta-description" placeholder="Enter blog meta description..."></textarea>
                            </div>
                        </div>
                    </div>

                    <div class="row p-2">
                        <div class="col-md-12" align="center">
                            <div class="form-group">
                                <h5 for="validationCustom01"><b>Brand :</b></h5>
                                <select class="form-control" name="edit_brandid" id="edit-brandid">
                                    <?php $__currentLoopData = $brands; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($row->id); ?>"><?php echo e($row->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row p-2">
                        <div class="col-md-12" align="center">
                            <div class="form-group">
                                <h5 for="validationCustom01"><b>Featured Image :</b></h5>
                                <img src="#" alt="" id="edit-blog-img" width="50%" height="200" />
                            </div>
                        </div>
                    </div>

                    <div class="row p-2">
                        <div class="col-md-12">
                            <div class="file-upload">
                              <button class="file-upload-btn" type="button" onclick="$('.file-upload-input').trigger( 'click' )">Add Image</button>

                              <div class="image-upload-wrap">
                                <input class="file-upload-input" type='file' name="edit_file" onchange="readURL(this);" accept="image/*" />
                                <div class="drag-text">
                                  <h3>Drag and drop a file or select add Image</h3>
                                </div>
                              </div>
                              <div class="file-upload-content">
                                <img class="file-upload-image" src="#" alt="your image" />
                                <div class="image-title-wrap">
                                  <button type="button" onclick="removeUpload()" class="remove-image">Remove <span class="image-title">Uploaded Image</span></button>
                                </div>
                              </div>
                            </div>
                        </div>
                    </div>

                    <div class="row p-2">
                        <div class="col-md-12" align="center">
                            <div class="form-group">
                                <button type="submit" class="btn btn-primary">Save</button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<div id="deleteblogModal" class="modal fade in" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-confirm modal-dialog-centered">
        <div class="modal-content">
            <!-- <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
            </div> -->
            <div class="modal-body" align="center">
                <img src="<?php echo e(asset('public/backend/img/close.png')); ?>" width="70" height="70">
                <h4 class="modal-title" style="color: #636363; margin-top: 10px;">Are you sure?</h4>
                <p style="color: #999999">Do you really want to deactivate this record?</p>
                <form method="POST" action="<?php echo e(route('delete_blog_post')); ?>">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="blog_id" class="deleteblogid">
                    <button type="submit" class="btn btn-danger">Yes</button>
                    <button type="button" class="btn btn-info" data-dismiss="modal">No</button>
                </form>
            </div>
            <!-- <div class="modal-footer" align="center">
            </div> -->
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('page_script'); ?>
<script src="<?php echo e(asset('public/backend/ckeditor/ckeditor.js')); ?>"></script>
<script src="<?php echo e(asset('public/backend/ckeditor/samples/js/sample.js')); ?>"></script>
<script src="<?php echo e(asset('public/backend/image-upload/upload.js')); ?>"></script>

<script>

    initSample();
    
    $(document).ready(function()
    {
        $(document).ready(function() {
            $("#add-blog-btn").validate();
        });
    
        $('.brand-assigning').select2({
            placeholder: "Select Brands"
        });
        
        $('#dt-basic-example').dataTable(
        {
            responsive: true,
            // "order": [[ 0, "asce" ]]
        });

    });
    
    $(document).on('click','.edit-blog', function(){
		var id = $(this).data('id');
		$.ajax({
			type: "GET",
			url: "<?php echo e(route('get_blog_by_id')); ?>",
			data: {
				blogid: id
			},
			success:function(result){
				$('#blog-id').val(result.message.id);
				$('#edit-title').val(result.message.title);
				CKEDITOR.instances['edit-description'].setData(result.message.description);
				$('#edit-meta-title').val(result.message.meta_title);
				$('#edit-meta-description').val(result.message.meta_description);
				
				if(result.message.image != ""){
				    $('#edit-blog-img').attr({
    					'src': "<?php echo e(asset('public/backend/img/blogs/')); ?>/" + result.message.image,
    					'alt': result.message.title
    				});    
				}else{
				    $('#edit-blog-img').attr({
				        'src': "<?php echo e(asset('public/backend/img/dummy.png')); ?>",
    					'alt': result.message.title
    				});
				}
				
				$('#edit-brandid').find('option[value="' + result.message.brand_id + '"]').attr("selected", true);
			}
		});
	});

	$(document).on('click','.delete-blog',function(){
            var rowid = $(this).data('rowid');
            $('.deleteblogid').val(rowid);
            $('#deleteblogModal').modal('show');
    });


</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/staffshaw/crm.staffshaw.com/resources/views/pages/blogs.blade.php ENDPATH**/ ?>